<?php
session_start(); 
require('fpdf/fpdf.php');
require('conexion.php');
class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}

function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}

function Header()
{
    // Logo
    $this->Image('logo.jpg',7,7,20);
    // Arial bold 15
    $this->SetFont('Arial','B',15);
    // Movernos a la derecha
    $this->Cell(80);
    // Título
    $this->Cell(0,0,'Servicios Integrales En Entidades De Salud',0,0,'C');
    // Salto de línea
	$this->ln(25);
}

function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',8);
	$this->Cell(100,10,'Historial medico',0,0,'L');

}


}
                 
	$paciente=$_SESSION['cedul'];
	$con = new DB;
	$pacientes = $con->conectar();	
	
	$strConsulta = "SELECT * from pacientes where id_benef =  '$paciente'";
	
	$pacientes = mysql_query($strConsulta);
	$fila = mysql_fetch_array($pacientes);
	$pdf=new PDF('L','mm','Letter');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(25,25,25);
	$pdf->Ln(10);
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,6,'Distrito: '.$fila['DISTRITO'],0,1);
	$pdf->Cell(0,6,'Usuario: '.$fila['nom_benef'].' '.$fila['email'].' '.$fila['genero'],0,1);
	$pdf->Ln(10);
	
	$pdf->SetWidths(array(20, 40, 55, 50, 60));
	$pdf->SetFont('Arial','B',10);
	$pdf->SetFillColor(114,180,255);
    $pdf->SetTextColor(255);

		for($i=0;$i<1;$i++)
			{
				$pdf->Row(array('FECHA','AUTORIZACION' ,'MEDICO', 'CONSULTORIO'));
			}
	
	$historial = $con->conectar();	
	$strConsulta = "SELECT autorizacion.fechaau,autorizacion.autno, autorizacion.dire, autorizacion.especialidad, red_atencion.nombre_prof 
	FROM autorizacion 
	Inner Join pacientes ON autorizacion.idpaciente = pacientes.id_benef 
	Inner Join red_atencion ON autorizacion.ipsate = red_atencion.nombre_prof
	WHERE pacientes.id_benef = '$paciente' ORDER by autorizacion.fechaau desc";
	
	$historial = mysql_query($strConsulta);
	$numfilas = mysql_num_rows($historial);
	
	for ($i=0; $i<$numfilas; $i++)
		{
			$fila = mysql_fetch_array($historial);
			$pdf->SetFont('Arial','',6);
			
			if($i%2 == 1)
			{
				$pdf->SetFillColor(255,255,255);
    			$pdf->SetTextColor(0);
				$pdf->Row(array($fila['fechaau'],$fila['autno'], $fila['nombre_prof'], $fila['especialidad']));
			}
			else
			{
				$pdf->SetFillColor(255,255,255);
    			$pdf->SetTextColor(0);
				$pdf->Row(array($fila['fechaau'],$fila['autno'],$fila['nombre_prof'],$fila['especialidad']));
			}
		}

$pdf->Output();
?>