<?php
session_start();
require('fpdf/fpdf.php');
require('conexion.php');
class PDF extends FPDF
{
var $widths;
var $aligns;
function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}
function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] :'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}
function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}
//cabezera
function Header()
{
    // Logo
    $this->Image('logo.jpg',30,12,27);
    // Arial bold 15
    $this->SetFont('Arial','B',7);
    // Movernos a la derecha
    $this->Cell(80);
    // Título
    $this->Cell(100,0,'Codigo: MC-HCL-01',0,0,'R',false);
    // Salto de línea
    $this->Ln(3);
	$this->Cell(180,1,'Version: 1.0',0,0,'R');
	 $this->Ln(3);
	$this->Cell(180,3,'Vigencia:01/06/2014',2,-10,'R');
    // Movernos a la derecha
    $this->Cell(120);
    // Salto de línea
    $this->Ln(1);
	$this->Cell(0,0,'',0,1,'C');
	$this->Ln(4);
$this->Cell(0,0,'HISTORIA CLINICA ODONTOLOGICA',0,1,'C');
}

//fin cabezera


//inicio pie de pagina
function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',4);
	$this->Cell(100,10,'Historia Clinica Impreso Por Sisclinic',0,0,'L');

}

//fin pie de pagina
//inicio identificacion
function ChapterTitle11($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Datos Identificacion",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin identificacion
//inicio motivo de consulta
function ChapterTitle($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Motivo de Consulta",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin motivo de consulta

//inicio antecedentesper
function ChapterTitle2($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Antecedentes Personales",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
	
}
//fin antecedentes per

//inicio antecedentes familiares
function ChapterTitle3($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Antecedentes Familiares",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin antecedentes

//inicio Revision por sistemas
function ChapterTitle4($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Revision por Sistemas",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin revision

//inicio examen fisico
function ChapterTitle5($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Examen Fisico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin examen fisico



//inicio examen fisico
function ChapterTitle6($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Seguimiento",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin examen fisico

//inicio examen fisico
function ChapterTitle7($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Seguimiento",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin examen fisico
function ChapterTitle8($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Educacion",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle10($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Diagnostico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle50($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Plan de tratamiento",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle555($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Radiologias",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}

function ChapterTitle5555($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Otros Examenes",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle1000($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(250,250,250);
    // Título
    $this->Cell(0,6,"Medico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle51($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Diagnostico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle52($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Medicamentos",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitleevo($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Evolucion Medica",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle54($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Datos Diagnostico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function ChapterTitle55($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Enfermedad Actual",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
function Chapterodonto($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Odontograma",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
}

	$pdf=new PDF('P','mm','Letter');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(25,25,25);
	$pdf->Ln(3);
    $pdf->ChapterTitle11($num,$title);
	$pdf->SetFont('Arial','',8);
	$paciente=$_SESSION['cedul'];
	$doc=$_SESSION['prof_h'];
	$est='1';
	$con = new DB;
	$pacientes = $con->conectar();	
	$us = $con->conectar();
	$recibe = "SELECT *FROM usuarios C,historiac P WHERE  P.admin='$paciente' and C.adm_num='$paciente'";
	$resultado = mysql_query($recibe);
	print mysql_error();
		$nfila=mysql_fetch_array($resultado);
	
$pdf->MultiCell(0,3,'Usuario:'.' '.$nfila['nom_uno'].' '.''.$nfila['nom_dos'].' '.''.$nfila['ape_uno'].' '.''.$nfila['ape_dos'].'                    '.'Sexo:'.'  '.$nfila['sexo_usu'].'        '.'Edad:'.''.$nfila['edad'].'                        '.'No de H.C. :'.$nfila['n_hc'].'',0,1);

    $pdf->MultiCell(0,3,'Fecha de Nacimiento:'.'  '.$nfila['fecha_nac'].' '.' '.' '.' '.' '.' '.' '.'Ocupacion:'.''.$nfila['ocup_usu'].' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' '.' ',0,1);

	$pdf->MultiCell(0,3,'Domicilio:'.'  '.$nfila['dire_usu'].' '.' '.' '.' '.' '.' '.' '.'Telefono:'.''.$nfila['celu_usu'].' '.' '.' '.' '.' '.' '.' '.' '.' '.'Fecha de Ingreso: '.' '.$nfila['fecha_ing'].' '.' '.' '.' '.' '.' '.' '.' '.' ',0,1);

	$pdf->Ln(1);
	
	$pdf->ChapterTitle($num,$title);
	$pdf->MultiCell(0,3,''.$nfila['motivo_consulta'].'',0,1);

    		
	$pdf->Ln(2);

    $enfermedad=$nfila['enfermedad_actual'];
    if($enfermedad==''){
    }else{
    $pdf->ChapterTitle55($num,$title);
	$pdf->MultiCell(0,3,''.$nfila['enfermedad_actual'].'',0,1);
	           }
	
	$pdf->Ln(2);
	$pdf->ChapterTitle2($num,$title);
	$pdf->MultiCell(0,3,''.$nfila['ant_personales'].'',0,1);
	
	$pdf->Ln(2);
	$pdf->ChapterTitle3($num,$title);
	$pdf->MultiCell(0,4,''.$nfila['ant_familiares'].'',0,1);
	
   	$pdf->Ln(2);
   	$evolucion=$nfila['evolucionmedica'];
    if($evolucion==''){
    }else{
	$pdf->ChapterTitleevo($num,$title);
	$pdf->MultiCell(0,4,''.$nfila['evolucionmedica'].'',0,1);
         }


		$pdf->Ln(2);
		$revision=$nfila['revision_sistema'];
		if($revision==''){
              }
		else{
     $pdf->ChapterTitle4($num,$title);
	$pdf->MultiCell(0,4,''.$nfila['revision_sistema'].'',0,1);

    }

    $pdf->Ln(2);
			$pdf->Ln(1);
	$pdf->ChapterTitle5($num,$title);
	$pdf->MultiCell(0,4,''.$nfila['observacionfisica'].'',0,1);
	$pdf->MultiCell(0,6,'Presion Arterial'.':'.' '.$nfila['tension'].' '.'  '.'  '.'  '.'Peso'.' : '.$nfila['peso'].'Kg'.' '.' '.'F. Cardiaca'.' '.$nfila['fcar'].' '.' '.' '.'Pulso'.' '.$nfila['pulso'].' ',0,1);
	$pdf->Ln(1);
	$cab=$nfila['cabeza'];
   if($cab=='anormal'){
	$pdf->MultiCell(0,6,'Art. Temporo-mandib'.' '.':'.' '.$nfila['cabeza'].','.''.$nfila['obscabeza'].' ',0,1);
	} else{

	}
 $ojo=$nfila['ojo'];
 if($ojo=='anormal'){
	$pdf->MultiCell(0,6,'Labios'.''.':'.' '.$nfila['ojo'].','.''.$nfila['obsojo'].' ',0,1);
}else{}

$oido=$nfila['oido'];
if($oido=='anormal'){
	$pdf->MultiCell(0,6,'Lengua'.''.':'.' '.$nfila['oido'].','.''.$nfila['obsoido'].' ',0,1);
    }else{}
    $nari=$nfila['nari'];
    if($nari=='anormal'){
    $pdf->MultiCell(0,6,'Paladar'.''.':'.' '.$nfila['nari'].','.''.$nfila['obsnari'].' ',0,1);
    }else{}
    
    $boca=$nfila['boca'];
    if($boca=='anormal'){
    $pdf->MultiCell(0,6,'Carrillos'.''.':'.' '.$nfila['boca'].','.''.$nfila['obsboca'].' ',0,1);
    }else{}
    
    $cuello=$nfila['cuello'];
    if($cuello=='anormal')
    {
    $pdf->MultiCell(0,6,'Glandulas salivales'.''.':'.' '.$nfila['cuello'].','.''.$nfila['obscuello'].' ',0,1);
    }else{}
    
    $torax=$nfila['torax'];
    if($torax=='anormal'){
    $pdf->MultiCell(0,6,'Sistema Vascular'.''.':'.' '.$nfila['torax'].','.''.$nfila['obstorax'].' ',0,1);
    }else{}
    
    $corazo=$nfila['corazon'];
    if($corazo=='anormal'){
    $pdf->MultiCell(0,6,'Maxilares'.''.':'.' '.$nfila['corazon'].','.''.$nfila['obscorazon'].' ',0,1);
    }else{
    }
    
    $pulmones=$nfila['pulmones'];
    if($pulmones=='anormal'){
    $pdf->MultiCell(0,6,'Senos Maxilares'.''.':'.' '.$nfila['pulmones'].','.''.$nfila['obspulmones'].' ',0,1);
    }else{}
    
    $abdo=$nfila['abdominales'];
    if($abdo=='anormal'){
    $pdf->MultiCell(0,6,'Musculos Masticadores'.''.':'.' '.$nfila['abdominales'].','.''.$nfila['obsabdominales'].' ',0,1);
    }else{
    }
    $orin=$nfila['orina'];
    if($orin=='anormal'){
    $pdf->MultiCell(0,6,'Piso de la boca'.''.':'.' '.$nfila['orina'].','.''.$nfila['obsorina'].' ',0,1);
    }else{}
     $muscu=$nfila['musculo'];
    if($muscu=='anormal'){
    $pdf->MultiCell(0,6,'Sistema Nervioso'.''.':'.' '.$nfila['musculo'].','.''.$nfila['obsmusculo'].' ',0,1);
    }else{}
    
    $pie=$nfila['piel'];
    if($pie=='anormal'){
    $pdf->MultiCell(0,6,'Funcion de oclusion'.''.':'.' '.$nfila['piel'].','.''.$nfila['obspiel'].' ',0,1);
    }else{
    }

    $sistema=$nfila['sistner'];
    if($sistema=='anormal'){
    $pdf->MultiCell(0,6,'Linfatico regional'.''.':'.' '.$nfila['sistner'].','.''.$resultado['obssisner'].' ',0,1);
    }else{}

    $pdf->Ln(2);

  	/**/
     	$recibe99 = "SELECT odon.admi,odon.identificacion,odon.descrip,odon.diente,odon.id_descrip,odon.observacion FROM odontograma odon WHERE odon.identificacion='1067715080' and odon.admi='1726'";
		$pdf->Chapterodonto($num,$title);
	$resultado99 = mysql_query($recibe99);
	print mysql_error();
		  while ($nfila99=mysql_fetch_array($resultado99)){
		    $pdf->Image("../../odontologia/plugins/odontograma/dataimg/10677150801726.jpg",80,22,35);
  }
	
	/**/
     	$recibe2 = "SELECT *FROM historia_diagnostico WHERE  id_adm='$paciente'";
		$pdf->ChapterTitle51($num,$title);
	$resultado2 = mysql_query($recibe2);
	print mysql_error();
		  while ($nfila2=mysql_fetch_array($resultado2)){
			$pdf->MultiCell(0,3,''.$nfila2['codigo'].'   '.$nfila2['diagnostico'].'',0,1);
		  }

		    	$recibe3 = "SELECT *FROM historia_planodontologia WHERE  id_admi='$paciente'";
		$pdf->ChapterTitle50($num,$title);
	$resultado3 = mysql_query($recibe3);
	print mysql_error();
		  while ($nfila3=mysql_fetch_array($resultado3)){
			$pdf->MultiCell(0,3,''.$nfila3['cups'].'  '.$nfila3['nombre'].'',0,1);
		  }
		  
    $pdf->Ln(15);

		   $recibe611 = "SELECT nombre,registro FROM profesional WHERE cedula='$doc'";

	$resultado611 = mysql_query($recibe611);
	print mysql_error();
		  while ($nfila611=mysql_fetch_array($resultado611)){

			  $pdf->MultiCell(0,3,''.$nfila611['nombre'].'',0,1);
			  $pdf->MultiCell(0,3,''.$nfila611['registro'].'',0,1);
	$pdf->ChapterTitle1000($num,$title);
		  }
$pdf->Ln();
$pdf->Output();
?>
