<?php
session_start();
require('fpdf/fpdf.php');
require('conexion.php');
class PDF extends FPDF
{
var $widths;
var $aligns;
function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}
function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] :'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}
//cabezera
function Header()
{
    // Logo
    $this->Image('logo.jpg',30,7,20);
    // Arial bold 15
    $this->SetFont('Arial','B',7);
    // Movernos a la derecha
    $this->Cell(80);
    // Título
    $this->Cell(100,0,'Codigo: MC-HCL-01',0,0,'R',false);
    // Salto de línea
    $this->Ln(3);
	$this->Cell(180,1,'Version: 1.0',0,0,'R');
	 $this->Ln(3);
	$this->Cell(180,3,'Vigencia:24/10/2014',2,-10,'R');
    // Movernos a la derecha
    $this->Cell(120);
    // Salto de línea
    $this->Ln(1);
	$this->Cell(0,0,'',0,1,'C');
	$this->Ln(4);
$this->Cell(0,0,'SOLICITUD DE MEDICAMENTOS',0,1,'C');
}

//fin cabezera


//inicio pie de pagina
function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',4);
	$this->Cell(100,10,'Formula Medica Impresa Por Sisclinic',0,0,'L');

}

//fin pie de pagina
//inicio identificacion
function ChapterTitle11($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',9);
    // Color de fondo
    $this->SetFillColor(220,220,220);
    // Título
    $this->Cell(0,6,"Datos Paciente",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin identificacion

function ChapterTitle1000($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','',9);
    // Color de fondo
    $this->SetFillColor(250,250,250);
    // Título
    $this->Cell(0,6,"Medico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//inicio motivo de consulta
function ChapterTitle($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',8);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Datos de La Atencion",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin motivo de consulta


//inicio antecedentes familiares
function ChapterTitle3($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',8);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Antecedentes Familiares",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin antecedentes

//inicio Revision por sistemas
function ChapterTitle4($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',8);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Revision por Sistemas",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin revision

//inicio examen fisico
function ChapterTitle51($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',9);
	
    // Color de fondo
    $this->SetFillColor(220,220,220);
    // Título
    $this->Cell(0,6,"Medicamentos",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin examen fisico


function ChapterTitle63($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','I',7);
 
    // Título
    $this->Cell(0,6,"Diagnostico",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}

}

	$pdf=new PDF('P','mm','Letter');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(25,25,25);
	$pdf->Ln(7);
    $pdf->ChapterTitle11($num,$title);
	$pdf->SetFont('Arial','I',7);
  
   $paciente=$_GET['med'];
     $doc=$_GET['pro'];
	$est='1';
	$con = new DB;
	$pacientes = $con->conectar();	
	$us = $con->conectar();
	$recibe = "SELECT *from usuarios C, historiac P WHERE C.adm_num='$paciente' and P.admin='$paciente' group by admin";
	$resultado = mysql_query($recibe);
	print mysql_error();
	
while($nfila=mysql_fetch_array($resultado)){
	
	$pdf->MultiCell(0,3,'Nombre:'.' '.$nfila['nom_uno'].' '.''.$nfila['nom_dos'].' '.''.$nfila['ape_uno'].' '.''.$nfila['ape_dos'].'                                                                   Fecha: '.$nfila['fecha_ing'].'',0,1);
	$pdf->Ln(1);
	
	$pdf->MultiCell(0,3,'Tipo Documento:'.' '.$nfila['tipo_id'].'       Identificacion:'.'   '.$nfila['id_usu'].'',0,1);

				$pdf->Ln(1);
	$pdf->MultiCell(0,3,'Sexo:'.'  '.$nfila['sexo_usu'].'    '.'Edad:'.''.$nfila['edad'].''.'            Ocupacion:'.$nfila['ocup_usu'].'',0,1);
	
	
				$pdf->Ln(1);


	$pdf->Ln(1);
	
	
     	$recibe2 = "SELECT *FROM historia_medicamentos WHERE  id_adm='$paciente'";
		$pdf->ChapterTitle51($num,$title);
	$resultado2 = mysql_query($recibe2);
	print mysql_error();
	$pdf->MultiCell(0,6,''.''.''.' Cantidad  '.' Presentacion '.'Posologia ',0,1);
		  while ($nfila2=mysql_fetch_array($resultado2)){
$pdf->MultiCell(0,6,''.''.''.'        '.$nfila2['cantidad'].'         '.' '.$nfila2['medicamentos'].' '.''.$nfila2['posologia'].' ',0,1);
		  }
	
		
	$pdf->Ln(7);
	$recibe3 = "SELECT *FROM historia_diagnostico WHERE  id_adm='$paciente'";
		$pdf->ChapterTitle63($num,$title);
	$resultado3 = mysql_query($recibe3);
	print mysql_error();
		  while ($nfila3=mysql_fetch_array($resultado3)){
			$pdf->MultiCell(0,6,'Codigo'.''.':'.' '.$nfila3['codigo'].' , '.'Dx:'.$nfila3['diagnostico'].' ',0,1);
		  }

}
	   $recibe611 = "SELECT nombre,registro,imagen FROM profesional WHERE cedula='$doc'";

	$resultado611 = mysql_query($recibe611);
	print mysql_error();
		  while ($nfila611=mysql_fetch_array($resultado611)){
          $pdf->Image($nfila611["imagen"],140,130,45);
		  }

	$pdf->Ln();
$pdf->Output();
?>
