<?php
session_start();
require('fpdf/fpdf.php');
require('conexion.php');
class PDF extends FPDF
{
var $widths;
var $aligns;
function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}
function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] :'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}
function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}
//cabezera
function Header()
{
    // Logo
    $this->Image('logo.jpg',30,12,24);
    // Arial bold 15
    $this->SetFont('Arial','B',9);
    // Movernos a la derecha
    $this->Cell(80);
    // Título
    // Salto de línea
    $this->Ln(1);
	$this->Cell(0,0,'CENTRO DE REHABILITACION RESPIRATORIO CREE IPS',0,1,'C');
	$this->Ln(3);
$this->Cell(0,0,'Nit.900577093-6',0,1,'C');
$this->Ln(3);
$this->Cell(0,0,'Calle 13 B bis # 14-66 Alfonso Lopez',0,1,'C');
$this->Ln(3);
$this->Cell(0,0,'Email. gerencia@siensas.com Tel. 5804229-3102865078',0,1,'C');
}

//fin cabezera


//inicio pie de pagina
function Footer()
{
	$this->SetY(-25);
	$this->SetFont('Arial','B',8);
	$this->Cell(170,10,'Esta factura de venta se asimila en sus efectos a una letra de cambio - (Articulo 774) del codigo de comercio',0,0,'C');
	$this->Ln(3);
$this->Cell(170,10,'La no cancelacion de esta factura ocasiona interes de mora del % mensual',0,0,'C');
$this->ln(3);
$this->Cell(170,10,'Resolucion Dian No. 240000031047 Expedida el 2014/03/27 de prefijo A  del 1 al 10000 ',0,0,'C');

$this->ln(10);
$this->Cell(170,10,'Impresa Por Software Sisclinic v.1.0',0,0,'R');
}



//fin pie de pagina
//inicio identificacion
function ChapterTitle11($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','B',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Datos Empresa",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin identificacion
//inicio motivo de consulta
function ChapterTitle($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','B',9);
    // Color de fondo
    $this->SetFillColor(200,220,220);
    // Título
    $this->Cell(0,6,"Datos de Paciente",0,1,'L',true);
    // Salto de línea
    $this->Ln(1);
}
//fin motivo de consulta

//inicio antecedentesper
function ChapterTitle2($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','B',9);
    // Color de fondo
    $this->SetFillColor(220,220,220);
    // Título
    $this->Cell(0,6,"DETALLE SERVICIO PRESTADO",5,10,'C',true);
    // Salto de línea
    $this->Ln(1);
	
}
//fin antecedentes per



//inicio examen fisico
function ChapterTitle5($num, $label)
{
    // Arial 12
    $this->SetFont('Arial','B',9);
    // Color de fondo
    $this->SetFillColor(220,220,220);
    // Título
    $this->Cell(0,6,"Detalle Servicios Prestados",0,1,'C',true);
    // Salto de línea
    $this->Ln(1);
}
//fin examen fisico


}

	$pdf=new PDF('P','mm','Letter');
	$pdf->Open();
	$pdf->AddPage();

	
	$paciente=371;
	$paciente=$_GET['idif'];
	$est='1';
	$con = new DB;
	$pacientes = $con->conectar();	
	$us = $con->conectar();
	$recibe = "SELECT *FROM facturacion P WHERE  P.fac_num='$paciente'";
	$resultado = mysql_query($recibe);
	print mysql_error();
		$nfila=mysql_fetch_array($resultado);
		$pdf->Ln(5);
		$pdf->SetFont('Arial','b',12);
		$pdf->MultiCell(180,0,'FACTURA DE VENTA No. A'.'  '.$nfila['fac_num'].'',10,'R');
		$pdf->SetMargins(25,25,25);
		$pdf->Ln(4);
		$pdf->SetFont('Arial','b',8);
		$pdf->MultiCell(0,0,'Fecha Facturacion:'.'  '.$nfila['fechaf'].'       '.'Fecha Vencimiento:'.$nfila['fechav'].'',0,'R');
		$pdf->SetMargins(25,25,25);
     	$pdf->Ln(5);
    

		$pdf->ChapterTitle11($num,$title);
		$pdf->SetFont('Arial','',9);
		$pdf->MultiCell(0,3,'Empresa Convenida:'.'  '.$nfila['nomresponsable'].'       '.'NIT.'.$nfila['idresponsable'].'',0,1);

					
		$pdf->Ln(2);
  	    $pdf->ChapterTitle($num,$title);
	    $pdf->SetFont('Arial','',9);
	    $pdf->MultiCell(0,4,'Identificacion:  '.$nfila['id_paciente'].'    '.'Nombre:  '.$nfila['nombre'].'         '.'Admision:  '.$nfila['adm_num'].'',0,1);
		$pdf->Ln(2);
		
		
 	$pdf->Ln(1);
	/*DATOS A FACTURAR*/
	$pdf->ChapterTitle5($num,$title);
 	$recibe3 = "SELECT *FROM ser_usu WHERE  n_factura='$paciente'";

	$resultado3 = mysql_query($recibe3);
    print mysql_error();
	$pdf->SetFont('Arial','B',10);

	$pdf->MultiCell(0,6,'Codigo'.''.'          '.'Cantidad'.'           '.'Descripcion'.'                      '.'Val. Unitario'.' ',0,1);

	while ($nfila3=mysql_fetch_array($resultado3)){
	$pdf->SetFont('Arial','',9);
     $numero3=$nfila3['valor'];
		         $tot3=number_format($numero3,2, ".", ",");

	$pdf->MultiCell(0,3,''.$nfila3['cups'].'      '.$nfila3['cantidad'].'          '.$nfila3['nombre'].'            '.$tot3.'',0,1);
	}


	/*FIN DATOS A FACTURAR*/
	
		$pdf->Ln(10);
      	$pdf->SetFont('Arial','B',10);
         $numeros=$nfila['subtotal'];
         $tots=number_format($numeros,2, ".", ",");

        	$pdf->MultiCell(0,6,''.'Subtotal'.'            '.' '.$tots.' ',0,1);

		$pdf->Ln(2);
               	$pdf->SetFont('Arial','B',10);

         $numerosd=$nfila['descuento'];
         $totsd=number_format($numerosd,2, ".", ",");

       $pdf->MultiCell(0,6,''.'-Descuento'.'        '.$totsd.' ',0,1);
	   $pdf->Ln(2);
	   $pdf->SetFont('Arial','B',10);
       $numerosd=$nfila['copago'];
       $totsdb=number_format($numerosdb,2, ".", ",");
	   $pdf->MultiCell(0,6,''.'-Bonos'.'               '.$totsdb.' ',0,1);
	   $pdf->Ln(2);
			$pdf->SetFont('Arial','B',10);

       $numerosdc=$nfila['cuotamo'];
       $totsdbc=number_format($numerosdbc,2, ".", ",");
    	$pdf->MultiCell(0,6,''.'-Cuota Mod'.'        '.$totsdbc.' ',0,1);

		$pdf->Ln(2);
		         $numero=$nfila['valtotal'];
		         $tot=number_format($numero,2, ".", ",");
			$pdf->SetFont('Arial','B',11);
			$pdf->MultiCell(0,6,''.'Valor Total'.'       '.$tot.' ',0,1);
	$pdf->Ln(80);
	

	

  	$pdf->MultiCell(0,6,''.'Responsable'.'                                                                            '.'Recibido'.' ',0,1);

$pdf->Ln(15);
		  
		
	$pdf->Ln();
$pdf->Output();
?>
